ROUND equ 8
;---  Procedure draws bumped horizontal lines with two textures both ----
;---  image and lighting map. Proc used also for some similar rendering -
;---- horizontal lines/triangle methods.. -------------------------------
;---  I calc texture pixel by :: col1*col2/256 --------------------------
;---  First stage rendering triangle routines in 3glass_tex.inc file. ---
bump_tex_line_z:
; in:
;        xmm0 - .ty1, .tx1, .ey1, ex1
;        xmm1 - .ty2, .tx2, .ey2, ex2
;        xmm2 - .by1, .bx1, .z1, x1
;        xmm3 - .by2, .bx2, .z2, x2
;        xmm4 - marker
;        eax  - x1
;        ebx  - x2
;        edi  - pointer to screen buffer
;        xmm6 - lo -> hi dword x_res, tex_shift, tex_x * 4,
;          tex size as dword integers


.x1         equ [ebp-4]
.x2         equ [ebp-8]
.dbx        equ [ebp-12]
.dby        equ [ebp-16]
.dex        equ [ebp-20]
.dey        equ [ebp-24]
.dz         equ [ebp-28]
.dtx        equ [ebp-32]
.dty        equ [ebp-36]

.cbx        equ [ebp-40]
.cby        equ [ebp-44]
.cex        equ [ebp-48]
.cey        equ [ebp-52]
.cz         equ [ebp-56]
.czbuff     equ [ebp-60]
.ctx        equ [ebp-64]
.cty        equ [ebp-68]
.c_scr      equ [ebp-72]
;.tsiz      equ [ebp-76]
.tex_x      equ dword[ebp-80]
.temp_esi   equ dword[ebp-84]
;.xres      equ dword[ebp-88]
;.draw_flag equ byte [ebp-89]
.y          equ dword [ebp-94]
.bmap       equ dword [ebp-98]        ; bump map pointer
.emap       equ dword [ebp-102]       ; env map pointer
.z_buff     equ dword [ebp-106]       ; z buffer
.tex_map    equ dword [ebp-110]       ; texture pointer
.cmp_const  equ [ebp-114]
.draw_flag  equ [ebp-116]
.draw_flag2 equ [ebp-118]
.y_min      equ [ebp-124]
.y_max      equ [ebp-122]

    .x_res     equ [ebp]
    .tex_shift equ [ebp+4]
    .tex_x4    equ [ebp+8]
    .tex_size  equ [ebp+12]
; include "labs.inc"


       push        ebp
       mov         ebp,esp
       sub         esp,180
       sub         ebp,32
       movups      .x_res,xmm6
       mov         .c_scr,edi
       packssdw    xmm2,xmm2
       movd        .y_min,xmm2
       movlhps     xmm0,xmm0
       movlhps     xmm1,xmm1
       mov         .y,ecx
       movaps      xmm2,xmm3
       movaps      xmm3,xmm5
       mov         cl,[draw_flag]
       mov         ch,cl
       mov         .draw_flag,cx
       mov         .draw_flag2,cx

       mov         edi,envmap
       cmp         .draw_flag,byte 3
       jne         @f
       mov         edx,edi
       movhlps     xmm2,xmm0
       movhlps     xmm3,xmm1
     @@:
       mov        .bmap,bump_map
       mov        .emap,edi
       mov        .z_buff,esi
       mov        .tex_map,edx
       mov        .x1,eax
       mov        .x2,ebx
;       xor         ebx,ebx
;       mov         eax,.x_res
;       cmp         dword .x1,eax
;       jge         .bl_end
;       cmp         dword .x2,ebx
;       jle         .bl_end
;       mov         ebx,.x2
       sub         ebx,eax ;.x1

       mov         ecx,.tex_x4
       cvtsi2ss    xmm4,ebx
       rcpss       xmm4,xmm4
       shr         ecx,2
       shufps      xmm4,xmm4,0
       mov         .tex_x,ecx
       subps       xmm1,xmm0
       subps       xmm3,xmm2
       movhps      .cz,xmm2
       movhps      .cey,xmm0
       movlps      .cby,xmm2
       movlps      .cty,xmm0

       mulps       xmm1,xmm4
       mulps       xmm3,xmm4
       movhps      .dz,xmm3
       movlps      .dty,xmm1
       movhps      .dey,xmm1
       movlps      .dby,xmm3
       xor         eax,eax
       cmp         dword .x1,eax  ; set correctly begin variable
       jge         @f             ; CLIPPING ON FUNCTION
                                  ; cutting triangle exceedes screen
       mov         ebx,.x1
       neg         ebx
       mov         dword .x1,eax
       cvtsi2ss    xmm7,ebx
       shufps      xmm7,xmm7,0
       mulps       xmm3,xmm7
       addps       xmm3,xmm2
       movlps      .cby,xmm3
       movhps      .cz,xmm3
       mulps       xmm1,xmm7
       addps       xmm1,xmm0
       movhps      .cey,xmm1
       movlps      .cty,xmm1
      @@:
       mov         eax,.x_res
       mov         ecx,.x2
       cmp         ecx,eax
       cmovg       ecx,eax
       ; calc memory begin in buffers
       mul         .y
       add         eax,.x1
       shl         eax,2
       mov         esi,eax
       add         esi,.z_buff       ; z-buffer filled with dd variables
;      mov         ecx,.x2
       sub         ecx,.x1
       mov         .czbuff,esi
       add         .c_scr,eax
       movups      xmm7,.cey
       movups      xmm6,.dey
       shufps      xmm7,xmm7,00011011b
       shufps      xmm6,xmm6,00011011b
       mov         edi,0x00070305
       movups      .dey,xmm6
       movups      .cey,xmm7
       mov         .cmp_const,edi
    ; I assume tex coords = bump coords
       cld
    .draw:
       push     ecx
       mov      edi,.czbuff      ; .czbuff current address in buffer
      ; .cz - cur z position
       movss    xmm1,.cz
       mov      eax,.cz
       comiss   xmm1,[edi]
       ja       .skip
       stosd
       cvtps2dq xmm1,xmm7
       sub      esp,8
       movlps   [esp],xmm1
       pop      eax esi
       mov      ecx,.tex_shift
       shl      eax,cl
       add      esi,eax          ; esi - current bump map index
       mov      edi,.tex_size
       and      esi,edi
       mov      eax,esi
       shl      eax,2
       add      eax,.tex_map
       mov      .temp_esi,eax
       xor      eax,eax
       xor      edx,edx

       movlps   xmm0,.cmp_const
       movlps   xmm6,.draw_flag2
       pcmpeqb  xmm0,xmm6
       pmovmskb ebx,xmm0
       test     ebx,011b
       jnz      .tex_only
       test     ebx,100b
       jnz      .2tex_only

       mov     edi,.tex_size
       mov     ebx,esi
       dec     esi
       and     esi,edi
       add     esi,.bmap
       xor     eax,eax
       lodsb

       mov     esi,ebx
       inc     esi
       and     esi,edi
       add     esi,.bmap
       xchg    eax,edx
       xor     eax,eax
       lodsb
       sub     eax,edx
       xchg    eax,edx

       mov     esi,ebx
       push    esi
       sub     esi,.tex_x
       and     esi,edi
       add     esi,.bmap
       xor     eax,eax
       lodsb

       pop     esi
       add     esi,.tex_x
       and     esi,edi
       add     esi,.bmap
       xchg    ebx,eax
       xor     eax,eax
       lodsb
       sub     eax,ebx
    ;  eax - horizontal sub    modificated x coord
    ;  edx - vertical   sub    modificated y coord
    ;  xmm1 - copy of cur env coords
    .2tex_only:
       sub     esp,8
       movhps  [esp],xmm1
       pop     ebx
       add     edx,ebx
       pop     ebx

       add     eax,ebx
       mov     ecx,.tex_shift
       shl     edx,cl
       add     edx,eax

       and     edx,edi
       mov     esi,edx
       shl     esi,2
       add     esi,.emap
       lodsd
       cmp     .draw_flag,byte 4
       je      .only_bump

       mov        esi,.temp_esi
   ;   bump = tex coords
       movd       xmm0,eax
       xorps      xmm1,xmm1
       punpcklbw  xmm0,xmm1
       movd       xmm2,[esi]
       punpcklbw  xmm2,xmm1
       pmullw     xmm0,xmm2
       psrlw      xmm0,8
       packuswb   xmm0,xmm1
       movd       eax,xmm0
     .only_bump:
       mov        edi,.c_scr
       stosd
       jmp        .skip
     .tex_only:
if 0
       ; attempt for bilinera filtering.....
       movups     xmm7,.cey
    ;   shufps  xmm7,xmm7,01001110b
       cvtdq2ps   xmm7,xmm7
       rcpps      xmm2,[correct_texf]
       mulps      xmm7,xmm2
       movaps     xmm2,xmm7
       cvttps2dq  xmm6,xmm7
       cvtdq2ps   xmm5,xmm6
       subps      xmm2,xmm5

       movlps     xmm3,[the_one]
       ; xm2 - l-h -> xf, yf
       subps      xmm3,xmm2
       ; xm3 - l-h ->  1-xf 1-yf
       movlhps    xmm3,xmm2  ; xm3: l-h -> 1-xf, 1-yf, xf, yf
       movlhps    xmm2,xmm3  ; xm2: l-h -> xf, yf, 1-xf, 1-yf
       shufps     xmm3,xmm3,10001000b ; l-h: 1-xf xf    1-xf xf
       shufps     xmm2,xmm2,01011111b ; l-h: 1-yf 1-yf  yf   yf
       mulps      xmm2,xmm3  ; xm2: l-h -> w1 - w4 as floats
       mulps      xmm2,[correct_texf]

       mov        eax,.tex_map
       cmp        byte .draw_flag,3
       cmovne     eax,.emap
       lea        ebx,.x_res
       call       bi_fil2
end if
       packuswb   xmm7,xmm7
       mov        edi,.c_scr
       mov        esi,.temp_esi
       movsd
    ;   movss      [edi],xmm7

     .skip:
       pop        ecx
       add        dword .czbuff,4
       add        dword .c_scr,4
       movups     xmm7,.cey
       movups     xmm6,.dey
       addps      xmm7,xmm6

       mov        eax,.dz
       movlps     xmm1,.cz
       addss      xmm1,.dz
       movups     .cey,xmm7
       movss      .cz,xmm1
   ;    add       .cz,eax
   ;    loop      .draw
       dec        ecx
       jnz        .draw
 .bl_end:
 ;      mov        esp,ebp
       add        esp,180
       pop        ebp
ret
